/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// Test Revolution and Extrusion

#include <StdAfx.h>
#include "funcheader.h"
#include "CConvenienceExports.h"


HRESULT TestExtrusion()
{

	START_METHOD("TestExtrusion")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IExtrusion *pExtrusion = NULL;
	status = CreateExtrusion(activeSketch, 0.1,0,0,0,1,"extrusion",&pExtrusion);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("CreateExtrusion");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	END_METHOD("TestExtrusion")
}

HRESULT TestRevolutionToDrawCone() 
{

	START_METHOD("TestRevolutionToDrawCone")

	HRESULT status = CONV_SUCCESS;

	double x=0.0, y=0.0,  z=0.0,  radius=0.1;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IVector *center = NULL;
	(GetCLASS(Vector))->CreateVector(x, y, z, &center);

	IGeometric *localGeometric = CAST(IGeometric, activeWorkplane);

	IGeometry *pzPlane = NULL;
	localGeometric->GetGeometry (&pzPlane);

	IDirection *pNormal = NULL;
	CAST(IPlane, pzPlane)->GetNormal(&pNormal);

	IVector *start = NULL;
	IVector *end = NULL;
	IBasicStraight *curve1 = NULL;
	ILine *pLine1 = NULL;

	(GetCLASS(Vector))->CreateVector(x, y, z, &start);
	(GetCLASS(Vector))->CreateVector(x+.1, y, z, &end);
	(GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start,end,&curve1);
	activeSketch->CreateLine(CAST(ICurve, curve1), &pLine1);

	IBasicStraight *curve2 = NULL;
	ILine *pLine2 = NULL;

	start = NULL;
	end = NULL;

	(GetCLASS(Vector))->CreateVector(x, y, z, &start);
	(GetCLASS(Vector))->CreateVector(x, y+.2, z, &end);
  (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start,end,&curve2);
	activeSketch->CreateLine(CAST(ICurve, curve2), &pLine2);

	IBasicStraight *curve3 = NULL;
	ILine *pLine3 = NULL;

	start = NULL;
	end = NULL;

	(GetCLASS(Vector))->CreateVector(x+.1, y, z, &start);
	(GetCLASS(Vector))->CreateVector(x, y+.2, z, &end);
  (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start,end,&curve3);
	activeSketch->CreateLine(CAST(ICurve, curve3), &pLine3);

	// Get active workplane
	activeGraphicDoc->GetActiveWorkplane(&activeWorkplane);

	ISketch *initialSketch = NULL;
	activeGraphicDoc->GetActiveSketch(&initialSketch);

	// create Axis .
	IBasicStraight *curve4 = NULL;
	ILine *pAxis = NULL;
	
	start = NULL;
	end = NULL;

	(GetCLASS(Vector))->CreateVector(x,y, z, &start);
	(GetCLASS(Vector))->CreateVector(x, y+0.2, z, &end);
	(GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start,end,&curve4);
	initialSketch->CreateLine(CAST(ICurve, curve4), &pAxis);

	//Set the axis as construction line
	pAxis->SetConstruction(VARIANT_TRUE);

	// revolution ....
	IDesign *pDesign = NULL;
	activePart->GetDesign(&pDesign);

	IRevolution *pRev = NULL;
	CreateRevolution(initialSketch,CAST(IGeometric, pAxis),6.28,0,0,1,"revolution",&pRev);

	status = CommitToProDESKTOP("CreateRevolution");
	CHECK_RETURN_STATUS(status)

/*
	//	activePart->GetDesign(&pDesign);
	IPartOthers *part1 = CAST(IPartOthers, activePart);
*/

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)
	
	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	END_METHOD("TestRevolutionToDrawCone")
}

HRESULT TestSweepToDrawPrism() 
{

	START_METHOD("TestSweepToDrawPrism")

	HRESULT status = CONV_SUCCESS;

	double x=0.0, y=0.0,  z=0.0,  radius=0.1;
	
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ISketch *initialSketch = NULL;
	activeGraphicDoc->GetActiveSketch(&initialSketch);


	IVector *center = NULL;
	(GetCLASS(Vector))->CreateVector(x, y, z, &center);

	IGeometric *localGeometric = CAST(IGeometric, activeWorkplane);

	IGeometry *pzPlane = NULL;
	localGeometric->GetGeometry (&pzPlane);

	IDirection *pNormal = NULL;
	CAST(IPlane, pzPlane)->GetNormal(&pNormal);

	IBasicStraight *curve1 = NULL;
	ILine *line1 = NULL;
 	
	IVector *start = NULL;
	IVector *end = NULL;

	(GetCLASS(Vector))->CreateVector(x, y, z, &start);
	(GetCLASS(Vector))->CreateVector(x+.1, y, z, &end);
  (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start,end,&curve1);
	activeSketch->CreateLine(CAST(ICurve, curve1), &line1);

	IBasicStraight *curve2 = NULL;
	ILine *line2 = NULL;

	start = NULL;
	end = NULL;

	(GetCLASS(Vector))->CreateVector(x, y, z, &start);
	(GetCLASS(Vector))->CreateVector(x, y+.2, z, &end);
  (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start,end,&curve2);
	activeSketch->CreateLine(CAST(ICurve, curve2), &line2);

	IBasicStraight *curve3 = NULL;
	ILine *line3 = NULL;

	start = NULL;
	end = NULL;

	(GetCLASS(Vector))->CreateVector(x+.1, y, z, &start);
	(GetCLASS(Vector))->CreateVector(x, y+.2, z, &end);
	(GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start,end,&curve3);
	activeSketch->CreateLine(CAST(ICurve, curve3), &line3);

	// Get frontal workplane
	IDesign *localDesign = NULL;
	activePart->GetDesign(&localDesign);

	ISet *workplanes = NULL;
	status = localDesign->GetWorkplanes(&workplanes);//declare
	CHECK_RETURN_STATUS(status)

	IIt *pIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(workplanes,&pIt);
	CHECK_RETURN_STATUS(status)

	IDispatch *pCurrentWorkplane = NULL;
	status = pIt->start(&pCurrentWorkplane); //This is the base workplane
	CHECK_RETURN_STATUS(status)

	pCurrentWorkplane = NULL;
	status = pIt->Next(&pCurrentWorkplane); //This is the frontal workplane
	CHECK_RETURN_STATUS(status)

	IWorkplane *currentWorkplane = NULL;
	currentWorkplane = CAST(IWorkplane, pCurrentWorkplane);

	// create new  sketch
	CString strSketch = "Sketch1";
	ISketch *pSketch = NULL;
	currentWorkplane->CreateSketch(strSketch.AllocSysString(),&pSketch);
	activeGraphicDoc->SetActiveSketch(pSketch);
	activeGraphicDoc->GetActiveSketch(&activeSketch);

	// create Axis ....

	localGeometric = CAST(IGeometric, currentWorkplane);

	pzPlane = NULL;
	localGeometric->GetGeometry (&pzPlane);

	IDirection *pNormal2 = NULL;
	CAST(IPlane, pzPlane)->GetNormal(&pNormal2);

	IBasicStraight *curve4 = NULL;
	ILine *line4 = NULL;

	start = NULL;
	end = NULL;

 	(GetCLASS(Vector))->CreateVector(x,y, z, &start);
	(GetCLASS(Vector))->CreateVector(x, y, z+0.2, &end);
	(GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start,end,&curve4);
	activeSketch->CreateLine(CAST(ICurve, curve4), &line4);

	//  Sweep ....
	ISweep *pSweep=NULL;
	status = CreateSweep(initialSketch,pSketch,1, "sweep",&pSweep);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("CreateSweep");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)
	
	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	END_METHOD("TestSweepToDrawPrism")
}

HRESULT DrawCircle() 
{

	START_METHOD("DrawCircle")

	HRESULT status = CONV_SUCCESS;

	double x=0.0, y=0.0,  z=0.0,  radius=0.1;
	
	// Get the application
	IApplication *pdApplication = NULL;
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IPartDocument *newPart = NULL;
	status = pdApplication->NewPart(&newPart);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IVector *center = NULL;
	status = (GetCLASS(Vector))->CreateVector(x, y, z, &center);
	CHECK_RETURN_STATUS(status)

	IGeometric *localGeometric = CAST(IGeometric, activeWorkplane);

	IGeometry *pzPlane = NULL;
	status = localGeometric->GetGeometry(&pzPlane);
	CHECK_RETURN_STATUS(status)

	IDirection *pNormal = NULL;
	status = CAST(IPlane, pzPlane)->GetNormal(&pNormal);
	CHECK_RETURN_STATUS(status)

	IBasicCircle *curve = NULL;
	status = (GetCLASS(BasicCircle))->CreateBasicCircle(center, pNormal, radius, &curve);
	CHECK_RETURN_STATUS(status)

	ILine *pCircle = NULL;
	status = activeSketch->CreateLine(CAST(ICurve, curve), &pCircle);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("CreateCircle");
	CHECK_RETURN_STATUS(status)

	END_METHOD("DrawCircle")
}

HRESULT DrawRectangle() 
{

	START_METHOD("DrawRectangle")

	HRESULT status = CONV_SUCCESS;

	double x=0.0, y=0.0,  z=0.0;
	
	// Get the application
	IApplication *pdApplication = NULL;
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IPartDocument *newPart = NULL;
	status = pdApplication->NewPart(&newPart);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IVector *center = NULL;
	status = (GetCLASS(Vector))->CreateVector(x, y, z, &center);
	CHECK_RETURN_STATUS(status)

	IGeometric *localGeometric = CAST(IGeometric, activeWorkplane);

	IGeometry *pzPlane = NULL;
	status = localGeometric->GetGeometry (&pzPlane);
	CHECK_RETURN_STATUS(status)

	IDirection *pNormal = NULL;
	status = CAST(IPlane, pzPlane)->GetNormal(&pNormal);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve1 = NULL;
	ILine *pLine1 = NULL;

	IVector *start = NULL;
	IVector *end = NULL;

 	status = (GetCLASS(Vector))->CreateVector(x, y, z, &start);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x+.2, y, z, &end);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start,end,&curve1);
	CHECK_RETURN_STATUS(status)
	
	status = activeSketch->CreateLine(CAST(ICurve, curve1), &pLine1);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve2 = NULL;
	ILine *pLine2 = NULL;

	start = NULL;
	end = NULL;

	status = (GetCLASS(Vector))->CreateVector(x, y, z, &start);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x, y+.2, z, &end);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start,end,&curve2);
	CHECK_RETURN_STATUS(status)
	
	status = activeSketch->CreateLine(CAST(ICurve, curve2), &pLine2);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve3 = NULL;
	ILine *pLine3 = NULL;

	start = NULL;
	end = NULL;

	status = (GetCLASS(Vector))->CreateVector(x, y+.2, z, &start);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x+.2, y+.2, z, &end);
	CHECK_RETURN_STATUS(status)
  
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start,end,&curve3);
	CHECK_RETURN_STATUS(status)
	
	status = activeSketch->CreateLine(CAST(ICurve, curve3), &pLine3);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve4 = NULL;
	ILine *pLine4 = NULL;

	start = NULL;
	end = NULL;

	status = (GetCLASS(Vector))->CreateVector(x+.2, y, z, &start);
	CHECK_RETURN_STATUS(status)

	status = (GetCLASS(Vector))->CreateVector(x+.2, y+.2, z, &end);
	CHECK_RETURN_STATUS(status)
	
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(start,end,&curve4);
	CHECK_RETURN_STATUS(status)
	
	status = activeSketch->CreateLine(CAST(ICurve, curve4), &pLine4);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("CreateRectangle");
	CHECK_RETURN_STATUS(status)

	END_METHOD("DrawRectangle")
}
